/************************************************************/
/*  Redblack medis, realizuotos Search ir Insert proceduras */
/************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdarg.h>
#include <alloc.h>
#include <iostream>
#include <time.h>

using namespace std;

typedef int T; 

#define compLT(a,b) (a < b)
#define compEQ(a,b) (a == b)

// RedBlack medzio apibrezimas:
            
typedef enum { BLACK, RED } nodeColor;

typedef struct Node_ 
{
	struct Node_ *kairen;         
	struct Node_ *desinen;        
	struct Node_ *tevas;       
	nodeColor color;            // spalva (juoda, raudona) 
	T data;                     // duomeonys, saugomi virsuneje
} Node;

#define NIL &sentinel
Node sentinel = { NIL, NIL, 0, BLACK, 0};

Node *root = NIL;               // saknis

void posukisKairen(Node *x) 
{

	Node *y = x->desinen;
	
	x->desinen = y->kairen;
	if (y->kairen != NIL) 
		  y->kairen->tevas = x;
	
// nustatoma y -> tevas rodykle
	if (y != NIL) 
		  y->tevas = x->tevas;
    if (x->tevas) 
    {
  	   if (x == x->tevas->kairen)
           x->tevas->kairen = y;
       else
           x->tevas->desinen = y;
     } 
     else 
     {
  	    root = y;
     }
 
      y->kairen = x;
      if (x != NIL) 
          x->tevas = y;
}

void posukisDesinen(Node *x) 
{

	Node *y = x->kairen;
	
// nustatoma x -> kairen rodykle
	x->kairen = y->desinen;
	if (y->desinen != NIL) 
        y->desinen->tevas = x;
	
// nustatoma y -> tevas rodykle
    if (y != NIL) 
  	    y->tevas = x->tevas;
    if (x->tevas) 
    {
  	    if (x == x->tevas->desinen)
            x->tevas->desinen = y;
        else
            x->tevas->kairen = y;
    } 
    else 
    {
  	    root = y;
    }

    y->desinen = x;
    if (x != NIL) 
    x->tevas = y;
}

void insertTaisymas(Node *x) 
{
     
// procedura RB medzio tvarkos issaugojimui
	
// tikrinimas
	while (x != root && x->tevas->color == RED) 
	{
	// o tai yra negerai, taigi taisom:
		if (x->tevas == x->tevas->tevas->kairen) 
		{
			Node *y = x->tevas->tevas->desinen;
            if (y->color == RED) 
            {
      	        // jei raudonas
      	        x->tevas->color = BLACK;
      	        y->color = BLACK;
      	        x->tevas->tevas->color = RED;
      	        x = x->tevas->tevas;
            } 
            else 
            {
      	        // jei juodas
      	        if (x == x->tevas->desinen) 
      	        {
  		        // nustatom kaip kairiji sunu
      		        x = x->tevas;
      		        posukisKairen(x);
                 }
                // keiciam spalva ir atliekam posuki
                x->tevas->color = BLACK;
                x->tevas->tevas->color = RED;
                posukisDesinen(x->tevas->tevas);
            }
         } 
         else 
         {
              // analogiskai, kaip auksciau
              Node *y = x->tevas->tevas->kairen;
	          if (y->color == RED)
   		      {
                           // jei raudonas
                           x->tevas->color = BLACK;
                           y->color = BLACK;
                           x->tevas->tevas->color = RED;
                           x = x->tevas->tevas;
              } 
              else 
              {
              //jei juodas
                   if (x == x->tevas->kairen) 
                   {
                         x = x->tevas;
                         posukisDesinen(x);
                         }
                   x->tevas->color = BLACK;
                   x->tevas->tevas->color = RED;
                   posukisKairen(x->tevas->tevas);
             }
         }
     }
     root->color = BLACK;
}

Node *insert(T data) 
{
     Node *current, *tevas, *x;
  	
//is karto ieskom, kur turetu buti irasinejamas elementas
	current = root;
	tevas = 0;
    while (current != NIL) 
    {
          if (compEQ(data, current->data)) 
              return (current);
          tevas = current;
          current = compLT(data, current->data) ?
          current->kairen : current->desinen;
    }

//tada ji irasom ir patikrinam ar viskas tvarkoj
    x = (Node*)malloc(sizeof(*x));
    if (x == 0) 
    {
          cout << "insufficient memory (insert)";
          exit(1);
    }
    x->data = data;
    x->tevas = tevas;
    x->kairen = NIL;
    x->desinen = NIL;
    x->color = RED;
  //iterpimas
    if(tevas) 
    {
               if(compLT(data, tevas->data))
                    tevas->kairen = x;
               else
                    tevas->desinen = x;
    } 
    else 
    {
         root = x;
    }
    insertTaisymas(x);
    return(x);
}

Node *search(T data) 
{
      
     Node *current = root;
     while(current != NIL)
     if(compEQ(data, current->data))
        return (current);
     else
        current = compLT (data, current->data) ?
        current->kairen : current->desinen;
     return(0);
}

  void menu() {
      cout << "\n";
	  cout << "\t 1 - RedBlack Medzio sudarymas\n\n";
	  cout << "\t 2 - Paieska \n\n";
	  cout << "\t 3 - Iterpimas\n\n";
	  cout << "\t 4 - Iseiti\n\n\n";
	  cout << "\t Pasirinkite veiksma ";
}

int main() 
{   int input = 0, Sk;
    int a, maxnum, ct;
    Node *t;
    do {
		menu();
		cin >> input;
		cout << endl;
		
		if(input == 1)
       {
    cout << "Iveskite RB medzio elementu skaiciu" << endl;
    cin >>maxnum;
    cout << "Iveskite medzio elementus "<<endl; 
    
             for (ct = maxnum; ct; ct--) 
           {
                cin >> a ;
                insert(a);
           }
           cout << "Medis sudarytas/papildytas" <<endl;     
           system("pause");
       }
       
        if(input == 2){
     Sk=0;
     cout << "Iveskite ieskomaji nari :"<<endl;
     cin >> a ;
     for (ct = maxnum; ct; ct--) 
    {
      if ((t = search(a)) != NULL)Sk=1;
    }
        if(Sk!=0)
            cout << "Elementas "  << a << " buvo rastas"<<endl;
         else cout << "Elemento " << a << " nerasta."<<endl;
            system("pause");        
      }  
        
     if(input == 3){
     cout << "Iveskite elementa kuri norite iterpti" << endl;
                cin >> a ;
                insert(a);
     cout << "Elementas " << a << " iterptas" << endl;
                system("pause");
      
    }

   if(input == 4)
     {
			break;
      }
   }
	while(true);

    return 0;

}

